<?php
/* --------------------------------------------------------------
   TrackingCodes.php 2020-03-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\TrackingCode\Model;

use Gambio\Admin\TrackingCode\Interfaces\TrackingCode;
use Gambio\Admin\TrackingCode\Interfaces\TrackingCodes as TrackingCodesInterface;
use Traversable;
use Webmozart\Assert\Assert;

/**
 * Class TrackingCodes
 *
 * @package Gambio\Admin\TrackingCode\Model
 */
class TrackingCodes implements TrackingCodesInterface
{
    /**
     * @var TrackingCode[]
     */
    private $ids;
    
    
    /**
     * TrackingCodes constructor.
     *
     * @param array $ids
     */
    private function __construct(array $ids)
    {
        $this->ids = $ids;
    }
    
    
    /**
     * @param TrackingCode ...$ids
     *
     * @return TrackingCodes
     */
    public static function create(TrackingCode ...$ids): TrackingCodes
    {
        return new self($ids);
    }
    
    
    /**
     * @param TrackingCode[] $ids
     *
     * @return TrackingCodes
     */
    public static function createWithReferences($ids): TrackingCodes
    {
        Assert::allIsInstanceOf($ids,
                                TrackingCode::class,
                                'All IDs need to implement the "' . TrackingCode::class . '" interface.');
        
        return new self($ids);
    }
    
    
    /**
     * @inheritDoc
     */
    public function getIterator(): Traversable
    {
        return new \ArrayIterator($this->ids);
    }
    
    
    /**
     * @inheritDoc
     */
    public function items(): array
    {
        return $this->ids;
    }
    
    
    /**
     * @inheritDoc
     */
    public function jsonSerialize(): array
    {
        return $this->items();
    }
}